//------------------------------------------------------------------------------
// File: svr_camera.cs
// Creates the datablock to use for the camera and contains other camera methods
// Copyright Sandlot Games, 2007
// Author: Matthew Rudge and Michael Felice
//------------------------------------------------------------------------------
datablock SLCameraData(GameCameraData)
{
	defaultFov = 11.0;
};

////////////////////////////////////////////////////////////////////////////////
//! Moves the camera to the desired position
//! \param %pos Position to move to
//! \param %fly True if the camera is to fly to the position, false to snap
////////////////////////////////////////////////////////////////////////////////
function SLCamera::moveToPosition(%this, %pos, %fly)
{
   %component = %this.getCameraCmp();
   if (isObject(%component))
   {
      %component.moveToPos(getWord(%pos, 0), getWord(%pos, 1), %fly);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Moves the camera to the desired object
//! \param %obj Object to move to
//! \param %fly True if the camera is to fly to the object, false to snap
////////////////////////////////////////////////////////////////////////////////
function SLCamera::moveToObject(%this, %obj, %fly)
{
   %this.moveToPosition(%obj.getPosition(), %fly);
}

///////////////////////////////////////////////////////////////////////////////
//! Indicates if the camera is moving to a position
//! \param %pos Position to move to
//! \param %fly True if the camera is to fly to the position, false to snap
////////////////////////////////////////////////////////////////////////////////
function SLCamera::isMovingToPos(%this)
{
   %component = %this.getCameraCmp();
   if (isObject(%component))
   {
      return %component.isMovingToPos();
   }
   else
   {
      return false;
   }
}
////////////////////////////////////////////////////////////////////////////////
//! Command from client to move the camera to a position
//! \param %client Client that sent command
//! \param %pos Position to move to
//! \param %fly True to fly to the position, false to snap
////////////////////////////////////////////////////////////////////////////////
function serverCmdMoveCameraToPosition(%client, %pos, %fly)
{
   %cam = %client.getCameraObject();
   if (isObject(%cam))
   {
      %cam.moveToPosition(%pos, %fly);
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Command from client to move the camera to an object
//! \param %client Client that sent command
//! \param %ghost Object to move to
//! \param %fly True to fly to the object, false to snap
////////////////////////////////////////////////////////////////////////////////
function serverCmdMoveCameraToObject(%client, %ghost, %fly)
{
   %obj = %client.resolveObjectFromGhostIndex(%ghost);
   %cam = %client.getCameraObject();
   if (isObject(%cam) && isObject(%obj))
   {
      %cam.moveToObject(%obj, %fly);
   }
}


function serverCmdPlayFocusAnimation(%client, %camera, %heroIndex)
{
   %datablock = $HeroObject[%heroIndex];
   %component = %camera.getCameraCmp();
   if (isObject(%component) == true)
   {
      %component.playAnimation(%datablock.portraitFocus);
   }
}

function serverCmdPlaySelectAnimation(%client, %camera0, %camera1, %camera2, %heroIndex)
{
   %cameraList[0] = %camera0.getCameraCmp();
   %cameraList[1] = %camera1.getCameraCmp();
   %cameraList[2] = %camera2.getCameraCmp();
   
   for (%index = 0; %index < 3; %index++)
   {
      %datablock = $HeroObject[%index];
      
      if (%heroIndex == %index)
      {
         %cameraList[%index].playAnimation(%datablock.portraitHappy);
      }
      else
      {
         %cameraList[%index].playAnimation(%datablock.portraitSad);
      }
   }
}


// End svr_camera.cs
